/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

//	OrientAxes.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CAssembly.h"
#include "CApplication.h"


HRESULT OrientAxes(IGeometric *pFirstGeometric, IGeometric *pSecondGeometric)
{
	START_METHOD("Orient Axes")

	HRESULT status=CONV_SUCCESS;
	VARIANT_BOOL bVal;

	IApplication *pdApplication = NULL;
	
	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// get the active part
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IObject *object1 = NULL;
	IObject *object2 = NULL;

	IGraphicDocument *pActiveDoc = NULL;
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	IGeometric *geometric = NULL;
	geometric = CAST(IGeometric,pSecondGeometric);

	IGeometric *pTemp = NULL;
	
	// UpdateDependencies method
	if (geometric->IsDependentOn(CAST(IGeometric,pFirstGeometric), &bVal)) {
		pTemp = pFirstGeometric;
		pFirstGeometric = pSecondGeometric;
		pSecondGeometric = pTemp;
	}

	IObject *pIns = NULL;
	status = CAST(IObject,pFirstGeometric)->GetParent(GetBSTR("DesignInstance"),&pIns);
	CHECK_RETURN_STATUS(status)

	IOrientGeometry *pMatingCondition = NULL;	

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);

	CString mcName("Orient");
	status = CAST(IOrientGeometryClass2, GetCLASS(OrientGeometry))->CreateOrientGeometry2(pDesign, pFirstGeometric, pSecondGeometric, 0.6, mcName.AllocSysString(), &pMatingCondition);
	CHECK_RETURN_STATUS(status)
 	
	IDesignInstance *ins = NULL;
	ins = CAST(IDesignInstance, pIns);
	status = ins->AddMatingCondition(CAST(IMatingCondition,pMatingCondition));
	CHECK_RETURN_STATUS(status);

	END_METHOD("Orient Axes")
}
